/*------------------------------------------------------------------------------*
 *	File Name: 	LABUTILS.h								 						*
 *	Purpose: functions in outil60.dll to be used in Origin C				   	*
 *  Creation:	9/21/2005, CPY													*
 *  	Copyright Originlab Corp. 2005		,									*
 *	Modification log	                                                        *
 *	EJP 2005-09-27 v8.0313 QA70-7473 ASC_IMP_MULT_DELIM							*
 *	DSC 10/5/05 v8.0315  FAST_MATCH_START_OF_STRING								*
 *	DSC 10/11/2005 FIND_FILES_GET_VERSION_OR_DATE								*
 *	YuI 02/13/07 SOME_AUTOUPDATE_CLEANUP										*
 *	Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS							*
 *	Hong 04/02/07 QA80-9561 v8.0594 SET_J_DOUBLE_BYTES_SUPPORT					*
 *	Hong 04/03/07 QA80-9561 v8.0595 FIX_STRING_PROCESS_ERROR_CAUSE_BY_CODE_PAGE	*
 *	AW 04/10/07 QA80-9548 v8.0598 XF_LOCALIZATION								*
 *	EJP 2007-04-19 v8.0605 QA70-9655 NEW_BROWSE_FOR_FOLDER_DLG					*
 *	EJP 2007-05-02 v8.0612 QA70-7296 FIX_FAILURE_TO_DEL_COL_WITH_PERIOD_IN_NAME	*
 *	EJP 2007-05-09 v8.0615 QA70-9731 MAKE_LABTALK_EXIST_FILETIME_AS_LOCALTIME	*
 *	Folger 09/07/07 NEED_TO_GET_PATCH_BUILD_VERSION_FROM_FILE_NAME				*
 *	Folger 09/18/07 ADD_COPY_DIRECTOTY_TO_COPY_FOLDER_RECURSIVELY				*
 *	Folger 11/21/07 GET_CURRENT_CODE_PAGE										*
 *	Folger 12/12/07 REWRITE_GET_ACP_TO_CHECK_CORRECT_CODE_PAGE_IN_JAPANESE		*
 *	DSC 3/19/08 QA70-10997 v8.0828 TEST_FOR_ADMININ_WHEN_WRITE_TO_EXE_PATH		*
 *	CPY 3/29/2008 COLORMAP_RAMP_CODE_CALLED_FROM_OC								*
 *	CPY 07/26/08 QA70-11868 AUTOMATIC_GENERATION_OF_COMMENTS_FOR_XF_OUTPUTS		*
 *	CPY 7/28/08 QA70-11868 XF_OUTPUT_COLS_AUTOSIZE_AFTER_SET_COMMENTS			*
 *	Kyle 11/17/08 QA80-12591 CORRECT_FORMULA_TO_COMPUTE_X_DATA_FOR_FITTED_CURVE	*
 *	ML 11/17/2008 NASTY_FLOATING_PROCESSOR_EXCEPTION_TROUBLES_DUE_TO_CALL_IN_C_TO_RETURN_DOUBLE_FUNCTION_FILE_WITHOUT_DECLARATION_BEING_SEEN
 *	Sim 11-26-2008 QA80-12318 TREE_DOUBLE_VALUE_COMPARE							*
 *	AW 12/08/2008 QA80-12748 ADD_LAST_ERROR_IN_OC								*
 *	CPY 12/11/08 QA70-12761 MONTH_NAME_FOR_OC_ACCESS							*
 *  Iris 03/03/2009 CUSTOMER_WANT_OC_SUPPORT_HEX2DEC							*
 *  Army 08/06/09 QA81-14051 V8.1076 ADD_WEEKDAYNAME_FUNCTION				    *
 *	Sim 12-07-2009 QA81-14641 LT_GETN_SUPPORT_DATE_TIME_PICKER					*
 *	Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT				*
 *	Kit 7/14/2010 ORG-570-P1 GENERATE_BETTER_SHORTNAME_IN_MATRIX_OBJECTS		*
 *	Kit 09/14/2010 ORG-864 NEED_LABUTIL_Get_grouping_type_IN_OC					*
 *	DSC 11/01/2010 ORG-1361 FOR_ACTIVATION_NEED_TO_TEST_FOR_ADMIN_ON_XP_TOO		*
 *------------------------------------------------------------------------------*/      

#ifndef _LABUTILS_H
#define _LABUTILS_H

#ifdef _WINDOWS // in VC
	#include "oc_types.h"  //CPY 7/28/08 QA70-11868 XF_OUTPUT_COLS_AUTOSIZE_AFTER_SET_COMMENTS
	#ifdef LABUTIL_TEXT_MATH
		#define LABUTILS_API __declspec(dllexport)
	#else
		#define LABUTILS_API __declspec(dllimport)
	#endif
	

	extern "C" {
#else // in Origin C
	#define LABUTILS_API
	#pragma dll(@OUTL)	// Associate all functions below to outil60.dll which must be in the Origin EXE folder
#endif	// !_WINDOWS

/**$
*/
LABUTILS_API BOOL is_data_selection_control_id(int nID);

/// Comments last updated by Cloud on 03/20/2007
/**$
*/
LABUTILS_API COLORREF	color_index_to_rgb(int nIndex, BOOL bRecycleIfOutOfRange = true);

/// Comments last updated by Cloud on 03/20/2007
/**$
*/
LABUTILS_API int		color_rgb_to_index(COLORREF crf, BOOL bFindNearest = true);

/// Comments last updated by Cloud on 03/20/2007
/**$
*/
LABUTILS_API BOOL		color_index_to_name(int nIndex, LPSTR lpszName, int nBufferSize);

/// EJP 2005-09-27 v8.0313 QA70-7473 ASC_IMP_MULT_DELIM
/// Comments last updated by Cloud on 03/20/2007
/**$
*/
LABUTILS_API LPSTR get_next_token_ptr(LPSTR lpszSource, LPCSTR lpcszDelimiters, char cQuote, BOOL bCombineConsecDelims, LPSTR lpszBuffer, int nBufferSize);
/// end ASC_IMP_MULT_DELIM

/// Iris 12/18/2008 SUPPORT_GET_MATCHBEGINPOS_AND_MATCHENDPOS
LABUTILS_API BOOL pattern_match( LPCTSTR strPattern, LPCTSTR strValue, BOOL bCaseSensitive, int *lpnMatchBeginPos = NULL, int *lpnMatchEndPos = NULL);
///end SUPPORT_GET_MATCHBEGINPOS_AND_MATCHENDPOS

///DSC 10/5/05 v8.0315  FAST_MATCH_START_OF_STRING
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_match_begin_(global_function)
*/
LABUTILS_API BOOL is_str_match_begin(LPCSTR lpcszStart, LPCSTR lpcsz);


///Comments last update by Cloud on 03/20/2007
/**# >
*/
LABUTILS_API BOOL set_parenth_use_angle_brackets(BOOL bSet);//--- DSC 10/10/05 v8.0316 QA70-8164 XF_ARG_NEEDS_ANGLE_BRACKETS

///Comments last update by Cloud on 03/20/2007
/**# >
*/
LABUTILS_API int match_begin_of_word_no_case(LPCSTR lpcszStrToFind, LPCSTR lpcszStrToSearch);//DSC 10/28/2005 SUPPORT_ORIGIN_PATH_UNDEF
//---- CPY 12/22/06 CELL_BIDIRECTIONAL_LINKING
/**$
*/
LABUTILS_API BOOL is_str_match_begin_sensitive(LPCSTR lpcszTest, LPCSTR lpcszStr);
//----

///end FAST_MATCH_START_OF_STRING

/// DSC 10/25/05 QA70-8131 ADD_GOOGLE_TYPE_SEARCH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_match_begin_of_word_(global_function)
*/
LABUTILS_API BOOL is_str_match_begin_of_word(LPCSTR lpcszStart, LPCSTR lpcsz, int* p_nIndex=NULL);
/// end ADD_GOOGLE_TYPE_SEARCH 

// Last Update : 2006.9.27 Cheney 
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_file_last_write_time_as_julian_(global_function)
*/
LABUTILS_API BOOL get_file_last_write_time_as_julian(LPCSTR lpcszFile, double* lpdLastWriteTime); /// DSC 10/11/2005 FIND_FILES_GET_VERSION_OR_DATE

// Last Update : 2006.9.27 Cheney 
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_file_time_(global_function)
*/
LABUTILS_API BOOL get_file_time(LPCSTR lpcszFile, double* pdLastWriteTimeJulian=NULL, double* pdCreationTimeJulian=NULL, LPSTR pszLastWriteYMDHMS=NULL, LPSTR pszCreationYMDHMS=NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_numeric_(global_function)
*/
LABUTILS_API BOOL is_str_numeric(LPCSTR lpcsz, double* lpVal = NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_numeric_integer_(global_function)
*/
LABUTILS_API BOOL is_str_numeric_integer(LPCSTR lpcszStr, int* lpnVal = NULL);	 

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_numeric_integer_with_args_(global_function)
*/
LABUTILS_API LPSTR is_str_numeric_integer_with_args(LPSTR lpsz, int* lpnVal, char cSeparator = ':');

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_end_char_(global_function)
*/
LABUTILS_API int str_end_char(LPCSTR lpcsz, int* nEndPos = NULL); 


///---Sim 11-26-2008 QA80-12318 TREE_DOUBLE_VALUE_COMPARE
enum
{
	ERROR_NO,
	ERROR_INVALID_DOUBLE_TEXT,
	ERROR_INVALID_DOUBLE_PRECISION,
};
/**$
	Parameters:
		lpcszStr1 = [input] compared double text
		lpcszStr2 = [input] compared double text
		nPrecision = [input] precision of double value
							-1	= Full Precision
							0	= Origin Default
							>0	= User Defined
		pnErr = [output] pointer of output error code
		
	Returns:
		TRUE if equal

	Example:	
	void test_is_str_double_equal_ex1()
	{
		char szDouble1[] = "1.2345";
		char szDouble2[] = "1.2345";
		ASSERT( is_str_double_equal(szDouble1, szDouble2) );
	}

	void test_is_str_double_equal_ex2()
	{
		char szDouble1[] = "1.2345";
		char szDouble2[] = "5.4321";
		ASSERT( !is_str_double_equal(szDouble1, szDouble2) );
	}
*/
LABUTILS_API BOOL is_str_double_equal(LPCSTR lpcszStr1, LPCSTR lpcszStr2, int nPrecision = 0, int *pnErr = NULL);
///---END QA80-12318 TREE_DOUBLE_VALUE_COMPARE


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:string_to_prefix_end_number_(global_function)
*/
LABUTILS_API int string_to_prefix_end_number(LPSTR lpszBuffer, LPCTSTR lpcszString);

//Category last updated by Justin 2007-04-02
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_good_C_identifier_(global_function)
*/
LABUTILS_API BOOL is_good_C_identifier(LPCSTR lpcsz, char cExtraAllowedChar = 0);

/// EJP 2007-05-02 v8.0612 QA70-7296 FIX_FAILURE_TO_DEL_COL_WITH_PERIOD_IN_NAME
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_good_C_identifier_ex_(global_function)
*/
LABUTILS_API BOOL is_good_C_identifier_ex(LPCSTR lpcsz, LPCSTR lpcszExtraAllowedChars);
/// end FIX_FAILURE_TO_DEL_COL_WITH_PERIOD_IN_NAME

//Comments last updated by Jospeh 08/08/07
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_to_date_(global_function)
*/
LABUTILS_API double str_to_date(LPCSTR lpcsz, int nFmt = LDF_SHORT);

///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
LABUTILS_API double str_to_time_ex(LPCSTR lpcsz, int nFmt = 0);
///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT

/// YuI 02/13/07 SOME_AUTOUPDATE_CLEANUP
LABUTILS_API DWORD get_time_duration(DWORD dwStartTickCount);
/// end SOME_AUTOUPDATE_CLEANUP

/// Hong 02/09/07 QA80-9360 ADD_COMPUTE_CHECK_SUM
LABUTILS_API WORD checksum_16bits(LPCSTR lpcBuff, int nLength);
/// end ADD_COMPUTE_CHECK_SUM

//---- CPY 2/4/2008 QA70-11042 CLICKED_CELL_BETTER_STATUS_DISPLAY
//Comments last updated by Iris 7/29/2008, added $
/**$
	divide data into two parts and call the checksum_16bits function twice to put 2nd part into hiword
*/
LABUTILS_API DWORD checksum_16bits_2_parts(LPCSTR lpcBuff, int count);
//----


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_key_hit_(global_function)
*/
LABUTILS_API BOOL is_key_hit(int nKey = VK_ESCAPE, BOOL bRemove = true, int nKeyState=0);

///Jasmine 03/26/07 MOVE_MAKE_FORMAT_STR_TO_LABUTILS, from frame.h
/**$
*/
LABUTILS_API BOOL make_format_str_from_numeric_settings_ex(
	LPSTR lpstr,
	int nFormat,
	int nSigDigits,
	BOOL bIsUseDecimalDigits,
	BOOL bRemoveEndZeros,
	BOOL bForEditing);
///End MOVE_MAKE_FORMAT_STR_TO_LABUTILS

#ifdef _WINDOWS // in VC
// not needed in OC yet
/**$
*/
LABUTILS_API void init_font(LOGFONT* lpLogFont, HWND hWnd = NULL, int nFontType = ANSI_FIXED_FONT,  int nPtsPerInch = 0);/// AW 04/10/07 QA80-9548 v8.0598 XF_LOCALIZATION
#endif //_WINDOWS

/// Hong 04/02/07 QA80-9561 v8.0594 SET_J_DOUBLE_BYTES_SUPPORT
/**$
	set code page type for string process
	Parameters:
			nCodePage = [input] code page type
	Example:	
	void test_code_page()
	{
		string str = "|abc"; //this string is generate in Chinese langauge system
		vector<string> vTmp;
		int nSize =0;

		int nOldCP = set_code_page_for_string_process(CP_Simplified_Chinese);

		nSize = str.GetTokens(vTmp, '|');

		set_code_page_for_string_process(nOldCP);

		out_int("nSize = ", nSize);
	}
	Returns:
		old value
*/
/// Hong 04/03/07 QA80-9561 v8.0595 FIX_STRING_PROCESS_ERROR_CAUSE_BY_CODE_PAGE
//LABUTILS_API int set_j_double_bytes(int nJDoubleByte);
//LABUTILS_API BOOL is_j_double_bytes();
typedef enum tagCODE_PAGE_TYPE
{
	CP_System	= -1,
	CP_Japanese = 932,
	CP_Simplified_Chinese = 936,
	CP_Korean = 949,
	CP_Traditional_Chinese = 950,	
	CP_US_ANSI	  = 1252,
	CP_Korean_Johab = 1361,
}CODE_PAGE_TYPE;

LABUTILS_API int set_code_page_for_string_process(CODE_PAGE_TYPE nCodePage);
/// end FIX_STRING_PROCESS_ERROR_CAUSE_BY_CODE_PAGE
LABUTILS_API BOOL is_lead_char_for_2byte(BYTE byChar);
/// end SET_J_DOUBLE_BYTES_SUPPORT

/// EJP 2007-04-19 v8.0605 QA70-9655 NEW_BROWSE_FOR_FOLDER_DLG
//Category last updated by Iris 7/29/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:browse_get_path_dialog_(global_function)
*/
LABUTILS_API int browse_get_path_dialog(HWND hwndOwner, LPSTR lpstrNewPath, LPCSTR lpcszDefPath, LPCSTR lpcszMsg, bool bShowFiles = false);
/// end NEW_BROWSE_FOR_FOLDER_DLG

/// EJP 2007-05-09 v8.0615 QA70-9731 MAKE_LABTALK_EXIST_FILETIME_AS_LOCALTIME
//Comments last updated by Iris 7/29/2008, added #
/**#
*/
LABUTILS_API double get_file_modify_date(LPCTSTR lpFileName);
/// end MAKE_LABTALK_EXIST_FILETIME_AS_LOCALTIME

//Category last updated by Iris 7/29/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_valid_file_path_(global_function)
*/
LABUTILS_API BOOL is_str_valid_file_path(LPCSTR lpFileName, int* pnCode = NULL);

//Category last updated by Iris 7/29/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_has_path_(global_function)
*/
LABUTILS_API BOOL is_str_has_path(LPCSTR lpFileName);

/// Iris 03/03/2009 CUSTOMER_WANT_OC_SUPPORT_HEX2DEC
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Hex2Dec_(global_function)
*/
LABUTILS_API int Hex2Dec(LPSTR lpszHex);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Bin2Dec_(global_function)
*/
LABUTILS_API int Bin2Dec(LPSTR lpszBin);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Byte2Hex_(global_function)
*/
LABUTILS_API bool Byte2Hex(BYTE bValue, LPSTR lpBuff);
///end CUSTOMER_WANT_OC_SUPPORT_HEX2DEC


///DSC 3/19/08 QA70-10997 v8.0828 TEST_FOR_ADMININ_WHEN_WRITE_TO_EXE_PATH
//LABUTILS_API BOOL is_path_normal_writable(LPCSTR lpcszPath);
#define IPNW_HAVE_VISTA_BUT_NOT_ADMIN	1
#define IPNW_PATH_NOT_WRITABLE			2
/**$
	test to see if path (must terminate with \) can be written (create file) to
	Parameters:
		lpcszPath = [input] path to check
		bRequireVistaAdmin = [input] if TRUE, require User is Admin if OS is Vista or Win 7. Use to avoid virtualization if lpcszPath is restricted area on Vista (like Program Files folder). .
		p_nError = [output]optional, if not NULL will return error code.
		bRequireAdminAllOS = [input] if TRUE, require User is Admin for any OS like XP, Vista, Win 7. Use TRUE to permit license activation.

	Return:
		true if can write to folder.
*/
///DSC 11/01/2010 ORG-1361 FOR_ACTIVATION_NEED_TO_TEST_FOR_ADMIN_ON_XP_TOO
// LABUTILS_API BOOL is_path_normal_writable(LPCSTR lpcszPath, BOOL bTestVistaAdmin = FALSE, int* p_nError = NULL);
LABUTILS_API BOOL is_path_normal_writable(LPCSTR lpcszPath, BOOL bRequireVistaAdmin = FALSE, int* p_nError = NULL, BOOL bRequireAdminAllOS = FALSE);
///end FOR_ACTIVATION_NEED_TO_TEST_FOR_ADMIN_ON_XP_TOO
/**$
*/
LABUTILS_API BOOL is_running_as_administrator(BOOL bCheckVistaOnly = FALSE);
///end MORE_TEST_FOR_ADMININ_WHEN_WRITE_TO_EXE_PATH
///end TEST_FOR_ADMININ_WHEN_WRITE_TO_EXE_PATH



//---- CPY 9/2/2007 FILE_COMPARE_USING_MARKO_ACCURATE_COMPARE_ACCROSS_COMPUTERS
// return -2 if either file does not existed
// return -1 if file2 time > f1	time
// return 1 if file1 time > file2 time
// return 0 if file2 and file has same last modified time
/**$
*/
LABUTILS_API int file_last_modified_time_compare(LPCSTR lpcszFile1, LPCSTR lpcszFile2);
//----

//------ Folger 09/07/07 NEED_TO_GET_PATCH_BUILD_VERSION_FROM_FILE_NAME
enum VERSION_ERROR_STATUS
{
	VERSION_ERROR_INVALID_VERSION_NUMBER_PAIR = -5,
	VERSION_ERROR_FROM_NOT_VALID_NUMBER,
	VERSION_ERROR_TO_NOT_VALID_NUMBER,
	VERSION_ERROR_GET_FROM_STRING,
	VERSION_ERROR_GET_TO_STRING,
	VERSION_ERROR_NO_ERROR,
};

// Filename assumption defined as STR_PATCH_FILE_NAME_FORMAT		"*-%d-*.exe"

LABUTILS_API int get_patch_build_version(LPCSTR lpcszPatchFile, int *pnVersionTo, int *pnVersionFrom);

LABUTILS_API BOOL find_lastest_patch(LPSTR lpszFilename, int nFromBuildNumber, LPCSTR lpcszPath);
//------ End NEED_TO_GET_PATCH_BUILD_VERSION_FROM_FILE_NAME

//------ Folger 09/18/07 ADD_COPY_DIRECTOTY_TO_COPY_FOLDER_RECURSIVELY
LABUTILS_API BOOL copy_directory(LPCSTR lpcszSourceDir, LPCSTR lpcszDestDir, BOOL bRecursive = FALSE, BOOL bSetNormalAttrib = true);
LABUTILS_API int copyfile(LPCSTR lpcszSource, LPCSTR lpcszDest, DWORD dwFlags=0); //---- CPY 9/26/2007 COPY_FOLDER_FOR_GROUP_NEED_RESET_ATTRIB
//------ End ADD_COPY_DIRECTOTY_TO_COPY_FOLDER_RECURSIVELY

//----- CPY 10/25/2007 QA70-10597 LOCALIZED_STR_ALLOW_TAB
//Comments last updated by Iris 7/29/2008, added $
/**$
 		expand string to replace C escape codes with ascii characters
	Parameters:
		lpstr = [input/output] buffer to be converted
		bCheckAddCR = [input] true will convert \n into ascii \r\n if not already preceeded by \r
	SeeAlso:
		ocu_make_C_string_from_ascii
*/
LABUTILS_API void expand_C_escape_codes(LPSTR lpstr, BOOL bCheckAddCR);

//Comments last updated by Iris 7/29/2008, added $
/**$
	get current language used inside Origin
	Parameters:
		lpstr = [output] optional pointer to a buffer to receive the language character string, like "E" for English, buffer must have a minimal size of 2
	Return:
		language enum like ORESLANG_ENGLISH, ORESLANG_JAPANESE etc
*/
LABUTILS_API int get_current_language(LPSTR lpstr = NULL);
//-----

//------ Folger 12/12/07 REWRITE_GET_ACP_TO_CHECK_CORRECT_CODE_PAGE_IN_JAPANESE
////------ Folger 11/21/07 GET_CURRENT_CODE_PAGE
//LABUTILS_API int get_ACP(BOOL *bCheck = NULL);
//Comments last updated by Iris 7/29/2008, added $
/**$
*/
LABUTILS_API int get_ACP(const char *pcLanguage = NULL, BOOL *pbCheck = NULL);
////------
//

//Comments last updated by Iris 7/29/2008, added #
/**#
	get a random number between 0 and 1 using GetTickCount() API function
	The advantage of this method is that the result is really random as long as you call it randomly with a time gap of at least a few seconds.
	Parameters:
		dwRemainder = [input] the part of the GetTickCount value to be used to return a value according to the following
		
		  (GetTickCount() & dwRemainder) / dwRemainder;

*/
LABUTILS_API double rnd_from_tick_count(DWORD dwRemainder = 0x01FF);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:log_file_(global_function)
*/
LABUTILS_API int log_file(LPCSTR lpcsz, BOOL bWrite);

//-------- CPY 3/29/2008 COLORMAP_RAMP_CODE_CALLED_FROM_OC
LABUTILS_API int	colormap_rgb_ramp(DWORD crfFirst, DWORD crfLast, UINT nSize, UINT* pRGBs, BOOL bMix, BOOL bCvtOColor=true);
LABUTILS_API DWORD	interpolate_crf(DWORD crfFirst, DWORD crfLast, UINT nTotalNum, int index, BOOL bMix);
//--------


//---- CPY 6/17/08 QA70-11637 DATA_DISPLAY_SHOWING_CORRECT_RANGE_INFO_BETTER_USE_PAGE_SHORT_NAME
/**$
*/
LABUTILS_API BOOL use_short_name_in_GUI(int nObjType, int nVal);
//----


//---- CPY 6/30/08 SystemTimeToJulianDate_Lack_Reverse_function_BUT_HONG_NEED_IN_SPC_MEMOBJ_NEW_CODE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:JulianDateToSystemTime_(global_function)
*/
LABUTILS_API BOOL JulianDateToSystemTime(const double* pdDate, SYSTEMTIME *pSysTime);
//----

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_has_space_(global_function)
*/
LABUTILS_API BOOL is_str_has_space(LPCSTR lpcsz, BOOL bExposedOnly = true);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_any_of_characters_in_str_(global_function)
*/
LABUTILS_API LPSTR find_any_of_characters_in_str(LPCSTR lpcsz, LPCSTR lpcszCharList, BOOL bIgnoreQuoted = false);

//-------- CPY 10/11/08 QA70-12361-P1 OPEN_EXCEL_SHOULD_LOCK_IT_WHEN_NOT_READ_ONLY	
/**$
	Abbreviate FileName by replacing middle path by ...
	Parameters:
		lpszFilename = [modify] file name buffer
		nMaxLength = attempt to shorten to this length if lpszFilename started out to be longer
		bAtLeastName = true will at least keep the full file name part, even if it is longer then nMaxLength
	Return:
		1 if buffer modified, 0 if not, < 0 for  errors
*/
LABUTILS_API int make_filename_shorter(LPSTR lpszFilename, int nMaxLength, BOOL bAtLeastName = true);
//--------

/// AW 12/08/2008 QA80-12748 ADD_LAST_ERROR_IN_OC
/**$
	Get Origin last error.
	Parameters:
		lpszBuff = [input] get error message when it is not NULL
		nBuffSize = [input] string buffer size to get error message 
	Return:
		error message, 0 if no error
*/
//LABUTILS_API int get_last_error(LPSTR lpszBuff = NULL, int nBuffSize = 0);
/**$
	Set Origin last error
	Parameters:
		nErr = [input] error codes
		lpcszStrForm = [input] error message  
*/
//LABUTILS_API void set_last_error(int nErr, LPCSTR lpcszStrForm = NULL); 
/// END ADD_LAST_ERROR_IN_OC

//---CPY 12/11/08 QA70-12761 MONTH_NAME_FOR_OC_ACCESS
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_month_name_(global_function)
*/
LABUTILS_API BOOL get_month_name(int nMonth, int nAbbriv, LPSTR lpszBuff, int nSize);

///Army 08/06/09 QA81-14051 V8.1076 ADD_WEEKDAYNAME_FUNCTION
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_weekday_name_(global_function)
*/
LABUTILS_API BOOL get_weekday_name(int nDayOfWeek, int nAbbriv, LPSTR lpszBuff, int nSize);
///End  ADD_WEEKDAYNAME_FUNCTION

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:int_to_fixed_str_(global_function)
*/
LABUTILS_API void int_to_fixed_str(int nVal, int nWidth, LPSTR lpszBuff);

//---end MONTH_NAME_FOR_OC_ACCESS

//---- CPY 7/28/08 QA70-11868 XF_OUTPUT_COLS_AUTOSIZE_AFTER_SET_COMMENTS
/**$
*/
LABUTILS_API BOOL init_autosize_limits(OGRIDLIMITS *pLimits, double dminCol = 1.5, double dmaxCol = 25, double dminRow = -1, double dmaxRow = -1);
//----


/// ML 11/17/2008 NASTY_FLOATING_PROCESSOR_EXCEPTION_TROUBLES_DUE_TO_CALL_IN_C_TO_RETURN_DOUBLE_FUNCTION_FILE_WITHOUT_DECLARATION_BEING_SEEN
/////Kyle 11/17/08 QA80-12591 CORRECT_FORMULA_TO_COMPUTE_X_DATA_FOR_FITTED_CURVE, move from common.h
//LABUTILS_API double        real_space(double x, BYTE space);/* x or log10(x) depends on space */
//LABUTILS_API double        real_inv_space(double x, BYTE space);/* x or exp(x) depends on space */
/////End CORRECT_FORMULA_TO_COMPUTE_X_DATA_FOR_FITTED_CURVE
/// end NASTY_FLOATING_PROCESSOR_EXCEPTION_TROUBLES_DUE_TO_CALL_IN_C_TO_RETURN_DOUBLE_FUNCTION_FILE_WITHOUT_DECLARATION_BEING_SEEN

///---Sim 12-07-2009 QA81-14641 LT_GETN_SUPPORT_DATE_TIME_PICKER
/**$
*/
LABUTILS_API LPCSTR get_date_format_str(int nDateType);
/**$
*/
LABUTILS_API LPCSTR get_time_format_str(int nTimeType);
///---END QA81-14641 LT_GETN_SUPPORT_DATE_TIME_PICKER
 
/// Kit 7/14/2010 ORG-570-P1 GENERATE_BETTER_SHORTNAME_IN_MATRIX_OBJECTS
//returns -1 if buffer size nSize too small
//returns -2 if index > 64k
//return string length if success
LABUTILS_API int generate_alpha_enum(char szBuffer[], int nSize, int index);

/// End GENERATE_BETTER_SHORTNAME_IN_MATRIX_OBJECTS

///-----Kit 09/14/2010 ORG-864 NEED_LABUTIL_Get_grouping_type_IN_OC
LABUTILS_API int get_grouping_type(int nPlotType);  
/// End NEED_LABUTIL_Get_grouping_type_IN_OC

#ifdef _WINDOWS
	}
#endif	//_WINDOWS

#endif //_LABUTILS_H


